------------------------------------------------------------
-- Flatten or Collapse All Transformations, Revision: 2.0
--
--
-- Use this simple script to toggle the state of the 'flatten 
-- transform' checkbox on a large number of transformation tools. 
-- You can flatten selected tools only, or all tools in the comp. 
--
-- written by Isaac Guenard (izyk@eyeonline.com)
-- May 21st, 2003
-- updated : Sept 27, 2005
-- changes : updated for 5
------------------------------------------------------------

local cnt = 0
local overall = 0

-- lets count how many of the xform tools in the flow are concatenated
for i, v in pairs(composition:GetToolList(false)) do
	if v.FlattenTransform then
		cnt = cnt + 1
		overall = overall + v.FlattenTransform[TIME_UNDEFINED]
	end
end

-- are over half of the xform tool concatenated?
if (overall / cnt) >= .5 then flatten = 0 else flatten = 1 end

-- use this to set the dialog default state
ret = composition:AskUser("Globally Modify Transformations", {
	{"Flatten", Name = "Flatten All Transforms",  "Checkbox", Default = flatten	},
	{"Selected", Name = "Affect Selected Tools Only", "Checkbox", Default = 0}
	})

if ret then
	for i, v in pairs(composition:GetToolList((ret.Selected == 1))) do
		if v.FlattenTransform then
			v.FlattenTransform = ret.Flatten
		end
	end
end

